#!/bin/bash

# Send Firefox Link to Server
# --------------------------------------------------------------------------

# for use with the "Send Link" firefox extension
# https://github.com/berrnd/send-link
# https://addons.mozilla.org/firefox/addon/send-link

# the copyparty server must have the wget hook enabled for this to work,
# see https://github.com/9001/copyparty/blob/hovudstraum/bin/hooks/wget.py
# and/or https://github.com/9001/copyparty/issues/437

# you also need to have write permissions on the volume that you are 
# downloading to

# --------------------------------------------------------------------------

# USAGE:
#  download this script and edit the variables below to your your copyparty 
#  server ip and (if required) your password 

#   * NOTE: just as a reminder, storing plaintext passwords in general is 
#     pretty bad since anyone with access to this file can see them, so if
#     you want more security you can, for example, encrypt your password
#     using gpg by running
#  echo "hunter2" | gpg --symmetric --cipher-algo AES256 -o cppPassword.gpg
#     and setting the enviroment variable to 
#  cppPassword=$(gpg --quiet --batch --decrypt cppPassword.gpg)

#cppPassword=hunter2
cppServer=127.0.0.1:3923

#  in the addon preferences, add these strings (without the hashtag):
#  Send to Server|mailto:%%u
#  Send to Shows|mailto:_SENDTOSHOWS_%%u
#  Send to Movies|mailto:_SENDTOMOVIES_%%u

#  in firefox, set the mailto protocol to use this script as the default,
#  then right click any file link you want to download on the server and 
#  select the "Send Link" option with your preferred destination

# --------------------------------------------------------------------------

# you can add your custom download locations by editing both this script
# and addon preferences as follows:

# addon:
#  add a new line with the name of your destination before the pipe character
#  (can be anything), and prepend a unique string before the two %% symbols
#  (preferrably surrounded by some characters or a unique enough sentence so 
#  that it its unlikely to appear in the actual url; this is what the script 
#  is looking for to determine the download location and will be discarded
#  to leave only the url)

# example:
#  Vault Files|mailto:_vault_%%u

# script:
#  copy the syntax from the following example:

# if the url contains the "_vault_" string at the start of the sentence,
# set the download location on the server to the "vault" folder, then
# remove the sentence from the url
# if [[ $s == "_vault_"* ]]; then
#  location=/vault/download/
#  s=${s/_vault_/}
#  fi

# --------------------------------------------------------------------------
# NOTE: make sure that the download location is url formatted, so that 
# spaces become %20 and such

# if [[ $s == "_vids_"* ]]; then
#  location=/my%20files/videos
#  s=${s/^vault^/}
#  fi
# --------------------------------------------------------------------------


s=$1

# the protocol itself is also attached as an argument, remove it
s=${s/mailto:/}

# default file location in downloads folder
location=/Downloads

# if specified, download to Movies folder
if [[ $s == "_SENDTOMOVIES_"* ]]; then
  location=/Media/Movies
  s=${s/_SENDTOMOVIES_/}
  fi

# if specified, download to Shows folder
if [[ $s == "_SENDTOSHOWS_"* ]]; then
  location=/Media/Shows
  s=${s/_SENDTOSHOWS_/}
  fi

# signal the server to actually start the download
# (set the enviroment variable or replace the variables with your actual
# server ip and password here)
curl $cppServer$location -X POST -H "pw: $cppPassword" --data-raw msg=$s
